﻿\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{InzWggios}[2018/09/01 Praca inzynierska Krakow, AGH WGGIOS]

\LoadClass[10pt, a4paper]{report}

%set proper margins
\RequirePackage[left=3.5cm, right=2.5cm, top=2.5cm, bottom=2.5cm]{geometry}

\RequirePackage{polski}
\RequirePackage[utf8x]{inputenc}
\RequirePackage[T1]{fontenc}

%used to generate current month in text
\RequirePackage{datetime2}

%to change unit separator
\RequirePackage{siunitx}

%figure and table format
\RequirePackage{graphicx}
\RequirePackage{float}
\RequirePackage[labelsep=period, font=it]{caption}

%to bibliography style
\RequirePackage{BibWggios}
%-------------for template--------------------------------------------------
\RequirePackage{makecell}

%page numering
\RequirePackage{scrpage2}

\RequirePackage{graphicx}
\RequirePackage{wrapfig}

\RequirePackage[table]{xcolor}
\RequirePackage{longtable}

\RequirePackage{tabu,multirow}

\RequirePackage{lmodern} %for resize box
\RequirePackage{environ} %for resize box

\newfloat{map}{tbph}{lop}[chapter]
\floatname{map}{Map}

\definecolor{gray}{RGB}{217,217,217}

\ifoot[]{}
\cfoot[]{}
\ofoot[\large\pagemark]{}
\pagestyle{scrplain}
%-----------------------------------ENVIRONMENTS----------------------------

%for resize box
\newdimen\fontdim
\newdimen\upperfontdim
\newdimen\lowerfontdim
\newif\ifmoreiterations
\fontdim12pt

\NewEnviron{fitbox}[2]{% \begin{fitbox}{<width>}{<height>} stuff \end{fitbox}
  \def\buildbox{%
    \setbox0\vbox{\hbox{\minipage{#1}%
      \fontsize{\fontdim}{1.2\fontdim}%
      \selectfont%
      \stuff%
    \endminipage}}%
    \dimen@\ht0
    \advance\dimen@\dp0
  }
  \def\stuff{\BODY}% Store environment body
  \buildbox
  % Compute upper and lower bounds
  \ifdim\dimen@>#2
    \loop
      \fontdim.5\fontdim % Reduce font size by half
      \buildbox
    \ifdim\dimen@>#2 \repeat
    \lowerfontdim\fontdim
    \upperfontdim2\fontdim
    \fontdim1.5\fontdim
  \else
    \loop
      \fontdim2\fontdim % Double font size
      \buildbox
    \ifdim\dimen@<#2 \repeat
    \upperfontdim\fontdim
    \lowerfontdim.5\fontdim
    \fontdim.75\fontdim
  \fi
  % Now try to find the optimum size
  \loop
    %\message{Bounds: \the\lowerfontdim\space
    %         \the\fontdim\space \the\upperfontdim^^J}
    \buildbox
    \ifdim\dimen@>#2
      \moreiterationstrue
      \upperfontdim\fontdim
      \advance\fontdim\lowerfontdim
      \fontdim.5\fontdim
    \else
      \advance\dimen@-#2
      \ifdim\dimen@<10pt
        \lowerfontdim\fontdim
        \advance\fontdim\upperfontdim
        \fontdim.5\fontdim
        \dimen@\upperfontdim
        \advance\dimen@-\lowerfontdim
        \ifdim\dimen@<.2pt
          \moreiterationsfalse
        \else
          \moreiterationstrue
        \fi
      \else
        \moreiterationsfalse
      \fi
    \fi
  \ifmoreiterations \repeat
  \box0% Typeset content
}
%-------------------------------------COMMANDS------------------------------
\newcommand{\signature}[3][0pt]{%      
  \begin{tabular}[t]{@{}l@{}}
  \makebox[#3]{\dotfill}\\
  \hspace{#1}#2
  \end{tabular}%
}

\newcommand{\dotrule}[1]{%
   \parbox[t]{#1}{\dotfill}}
   
\newcommand{\cellupspace}{\rule{0pt}{1em}}
\newcommand{\celldownspace}{\rule[-0.6em]{0pt}{0.6em}}

\newcommand{\listofmaps}{\listof{map}{Spis map}}
%---------------------------------------------------------------------------
\setlength{\parindent}{1.25cm}

\newcommand{\unit}{%
    \@ifstar
        \@unitnospace%
        \@unitwithspace%
}
\newcommand{\@unitnospace}[2]{\num[output-decimal-marker={.}]{#1}#2}
\newcommand{\@unitwithspace}[2]{\num[output-decimal-marker={.}]{#1}~#2}

\linespread{1.3}

\newcommand*{\polishmonthname}[1]{%
\ifcase#1
\or
styczeń%
\or
luty%
\or
marzec%
\or
kwiecień%
\or
maj%
\or
czerwiec%
\or
lipiec%
\or
sierpień%
\or
wrzesień%
\or
październik%
\or
listopad%
\or
grudzień%
\fi
}

\newcommand{\actualmonth}{\polishmonthname{\@dtm@month}}
\newcommand{\actualyear}{\@dtm@year}

\newcommand{\tytul}[1]{\gdef\@title{#1}}
\newcommand{\tytulang}[1]{\gdef\@englishtitle{#1}}
\newcommand{\autor}[1]{\gdef\@author{#1}}
\newcommand{\nralbumu}[1]{\gdef\@albumid{#1}}
\newcommand{\kierunek}[1]{\gdef\@fieldofstudy{#1}}
\newcommand{\katedra}[1]{\gdef\@cathedral{#1}}
\newcommand{\promotor}[1]{\gdef\@promoter{#1}}
\newcommand{\recenzent}[1]{\gdef\@reviewer{#1}}

\newcommand\printtitle{\@title}
\newcommand\printenglishtitle{\@englishtitle}
\newcommand\printauthor{\@author}
\newcommand\printalbumid{\@albumid}
\newcommand\printfieldofstudy{\@fieldofstudy}
\newcommand\printcathedral{\@cathedral}
\newcommand\printpromoter{\@promoter}
\newcommand\printreviewer{\@reviewer}

\renewcommand{\figurename}{Fig.}
\renewcommand{\tablename}{Tab.}

%------------------------------TITLE PAGE-------------------------------------
\renewcommand{\maketitle}{
\bgroup
\newpage
\pagenumbering{gobble}

\begin{wrapfigure}[4]{l}{0.15\textwidth}
    \raisebox{0pt}[\dimexpr\height-1.0\baselineskip\relax]{
    \centering\includegraphics[width=0.15\textwidth]{logo}}
\end{wrapfigure}

\setlength{\parskip}{1em}
\setlength{\parindent}{0ex}

\hspace{1cm}\textbf{\textit{\large Akademia Górniczo-Hutnicza im. Stanisława Staszica}}

\hspace{1cm}\textbf{\large Wydział Geologii, Geofizyki i Ochrony Środowiska}

\hspace{1cm}\textbf{\large Al. Mickiewicza 30}\newline
\null\hspace{1cm}\textbf{\large 30-059 Kraków}
\newline

\begin{center}
    \textbf{\Large OCENA PROJEKTU INŻYNIERSKIEGO}
\end{center}

\linespread{1.3}\large
IMIĘ I NAZWISKO DYPLOMANTA: \printauthor\newline
\normalsize Nr albumu: \printalbumid\newline
KIERUNEK: \printfieldofstudy\newline
JEDNOSTKA DYPLOMUJĄCA (katedra): \printcathedral\newline

\newlength{\titlelength}
\settowidth{\titlelength}{\printtitle}
\newlength{\englishtitlelength}
\settowidth{\englishtitlelength}{\printenglishtitle}

\large
\ifdim\titlelength>1000pt
\begin{fitbox}{\textwidth}{50pt}
TYTUŁ PRACY ({\normalsize wersja polska}): \printtitle
\end{fitbox}
\else
TYTUŁ PRACY ({\normalsize wersja polska}): \printtitle
\fi
\vspace{0.3cm}

\normalsize 
\ifdim\englishtitlelength>1000pt
\begin{fitbox}{\textwidth}{50pt}
TYTUŁ PRACY (wersja angielska): \printenglishtitle
\end{fitbox}
\else
TYTUŁ PRACY (wersja angielska): \printenglishtitle
\fi
\vspace{0.3cm}

\large
PROMOTOR: \printpromoter\newline
RECENZENT: \printreviewer

\linespread{1.0}
\begin{center}
    \textbf{\Large Ocena projektu inżynierskiego}
\end{center}

PROMOTORA: \dotfill RECENZENTA: \dotfill\newline

\textbf{\Large Końcowa ocena liczbowa i słowna \dotfill\hfill\null\newline}
\null\hspace{3em}\normalsize(średnia ocen promotora i recenzenta)


Skala ocen (wg Regulaminu Studiów AGH, §27):\newline
1) od 3 do 3,20 ocena słowna: dostateczny (3.0),\newline
2) od 3,21 do 3,70 ocena słowna: plus dostateczny (3.5),\newline
3) od 3,71 do 4,20 ocena słowna: dobry (4.0),\newline
4) od 4,21 do 4,70 ocena słowna: plus dobry (4.5),\newline
5) od 4,71 ocena słowna: bardzo dobry (5.0).
\vfill
\begin{flushright}
    \signature[0.2in]{Podpis przewodniczącego komisji}{2.4in}
\end{flushright}

\large
\begin{center}
    \textbf{Kraków, \actualmonth, \actualyear}
\end{center}

\newpage

\pagenumbering{arabic}
\stepcounter{page}

\null\vspace{1pt}
\begin{center}
    OŚWIADCZENIE AUTORA PRACY
\end{center}

\normalsize
Uprzedzony(-a) o odpowiedzialności karnej na podstawie art. 115 ust. 1 i 2 ustawy z dnia 4~lutego 1994 r. o prawie autorskim i prawach pokrewnych (t.j. Dz.U. z 2018 r. poz. 1191 z późn. zm.): „Kto przywłaszcza sobie autorstwo albo wprowadza w błąd co do autorstwa całości lub części cudzego utworu albo artystycznego wykonania, podlega grzywnie, karze ograniczenia wolności albo pozbawienia wolności do lat 3. Tej samej karze podlega, kto rozpowszechnia bez podania nazwiska lub pseudonimu twórcy cudzy utwór w wersji oryginalnej albo w postaci opracowania, artystyczne wykonanie albo publicznie zniekształca taki utwór, artystyczne wykonanie, fonogram, wideogram lub nadanie.”, a także uprzedzony(-a) o odpowiedzialności dyscyplinarnej na podstawie art. 307 ust. 1 ustawy z dnia 20 lipca 2018 r. Prawo o szkolnictwie wyższym i nauce (Dz. U. z 2018 r. poz. 1668 z późn. zm.) „Student podlega odpowiedzialności dyscyplinarnej za naruszenie przepisów obowiązujących w uczelni oraz za czyn uchybiający godności studenta.”, oświadczam, że niniejszą pracę dyplomową wykonałem(-am) osobiście i samodzielnie i nie korzystałem(-am) ze źródeł innych niż wymienione w pracy.

Jednocześnie Uczelnia informuje, że zgodnie z art. 15a ww. ustawy o prawie autorskim i prawach pokrewnych Uczelni przysługuje pierwszeństwo w opublikowaniu pracy dyplomowej studenta. Jeżeli Uczelnia nie opublikowała pracy dyplomowej w terminie 
6 miesięcy od dnia jej obrony, autor może ją opublikować, chyba że praca jest częścią utworu zbiorowego. Ponadto Uczelnia jako podmiot, o~którym mowa w art. 7 ust. 1 pkt 1 ustawy z dnia 20 lipca 2018 r. – Prawo o szkolnictwie wyższym i~nauce (Dz. U. z 2018 r. poz. 1668 z późn. zm.), może korzystać bez wynagrodzenia i~bez konieczności uzyskania zgody autora z utworu stworzonego przez studenta w wyniku wykonywania obowiązków związanych z odbywaniem studiów, udostępniać utwór ministrowi właściwemu do spraw szkolnictwa wyższego i nauki oraz korzystać z utworów znajdujących się w prowadzonych przez niego bazach danych, w celu sprawdzania z wykorzystaniem systemu antyplagiatowego. Minister właściwy do spraw szkolnictwa wyższego i nauki może korzystać z prac dyplomowych znajdujących się w prowadzonych przez niego bazach danych w zakresie niezbędnym do zapewnienia prawidłowego utrzymania i rozwoju tych baz oraz współpracujących z nimi systemów informatycznych.

\large
\vspace{50pt}
\signature[0.4in]{(data)}{1.5in} \hfill \signature[0.7in]{(czytelny podpis studenta)}{2.9in}

\vspace{64pt}
\begin{center}
    \textbf{Jednostka dyplomująca}\\
    (pieczęć i podpis kierownika)
\end{center}

\newpage

\egroup
}
%--------------------------ABSTRACT----------------------------------
\newlength{\streszczenielength}
\newlength{\abstractlength}

\environbodyname\innerBODY
\NewEnviron{streszczenie}[1]{
\settowidth{\streszczenielength}{\innerBODY}
\ifdim\streszczenielength>200pt
\begin{fitbox}{\textwidth}{200pt}
\begin{center}
\textbf{STRESZCZENIE PRACY}
\end{center}
\innerBODY
\begin{center}\textbf{Słowa kluczowe:} #1\end{center}
\end{fitbox}
\vfill
\else
\begin{center}
\textbf{STRESZCZENIE PRACY} (do 8 zdań)
\end{center}
\innerBODY
\begin{center}\textbf{Słowa kluczowe:} #1\end{center}
\vfill
\fi
}

%\environbodyname\innerBODY
\RenewEnviron{abstract}[1]{
\settowidth{\abstractlength}{\innerBODY}
\ifdim\abstractlength>200pt
\begin{fitbox}{\textwidth}{200pt}
\begin{center}
\textbf{ABSTRACT}
\end{center}
\innerBODY
\begin{center}\textbf{Key words:} #1\end{center}
\end{fitbox}
\vfill
\else
\begin{center}
\textbf{ABSTRACT}
\end{center}
\innerBODY
\begin{center}\textbf{Key words:} #1\end{center}
\vfill
\fi
}
%------------------------EVALUATION FORM-----------------------------
\newcommand{\makeevaluationform}{
\bgroup
\newpage

\begin{center}
    \textbf{\small FORMULARZ OCENY PUNKTOWEJ PROJEKTU INŻYNIERSKIEGO}
\end{center}

\small
\begin{center}
  \begin{tabu} to 14.63cm { |[1.3pt] X | l | l |[1.3pt] }
    \tabucline[1pt]{}
    \tabulinesep=3.2mm
    \makecell[cc]{\textbf{\large Oceniany element projektu}}
    & \textbf{\small\makecell{Ocena \\ promotora}}
    & \textbf{\small\makecell{Ocena \\ recenzenta}} \\ \hline
    
    \multicolumn{3}{|[1.3pt]c|[1.3pt]}{\tabulinesep=2.0mm
    \makecell{\small\textbf{I. ZAWARTOŚĆ MERYTORYCZNA [0 – 80 pkt]}}
    } \\ \hline
    
    \makecell[lc]{\cellupspace\textbf{1.} Zgodność treści projektu z tytułem.} & \multirow{2}{*}{} & \multirow{2}{*}{} \\
    \makecell{\celldownspace\textbf{\lbrack0 – 10 pkt\rbrack}} & & \\ \hline
    
   \makecell[cl]{\cellupspace\textbf{2.} Literatura (poprawność opracowania wykazu literatury, \\ kompletność danych bibliograficznych, poprawność cytowań).} 
    & \multirow{2}{*}{} & \multirow{2}{*}{} \\
    
    \makecell{\celldownspace\textbf{\lbrack0 – 10 pkt\rbrack}} & & \\ \hline
    
    \makecell[cl]{\cellupspace\textbf{3.} Metodyka badań (dobór właściwych metod badawczych \\
    i umiejętność ich zastosowania).} & \multirow{2}{*}{} & \multirow{2}{*}{} \\
    
    \makecell{\celldownspace\textbf{\lbrack0 – 20 pkt\rbrack}} & & \\ \hline
    
    \makecell[cl]{\cellupspace\textbf{4.} Dyskusja wyników badań i wnioski (logiczność wywodów, \\ poprawność i krytyczna analiza wyników badań, znaczenie naukowe \\
        i praktyczne, w jakim stopniu uzyskane wyniki są własnością \\
        intelektualną studenta).} & \multirow{2}{*}{} & \multirow{2}{*}{} \\
    
    \makecell{\celldownspace\textbf{\lbrack0 – 40 pkt\rbrack}} & & \\ \tabucline[1.3pt]{}
    
    \multicolumn{1}{|[1.3pt]l|[0.65pt]}{\tabulinesep=1mm\small\textbf{\hspace{5mm}\makecell[cl]{Zawartość merytoryczna łącznie \\
    (suma punktów w wierszach: 1-4)
    }}} 
    & \multicolumn{1}{|[0.65pt]l|[0.65pt]}{\cellcolor{gray}}
    & \multicolumn{1}{|[0.65pt]l|[1.3pt]}{\cellcolor{gray}} \\ \tabucline[1.3pt]{}
    
    \multicolumn{3}{|[1.3pt]c|[1.3pt]}{\tabulinesep=2.0mm\makecell{\textbf{\small II. STRONA EDYTORSKA [0 – 20 pkt]}}} \\ \hline
    
    \makecell[cl]{\cellupspace\textbf{1.} Poprawność składniowa, gramatyczna i ortograficzna projektu, \\
    staranność korekty tekstu.} & \multirow{2}{*}{} & \multirow{2}{*}{} \\
    
    \makecell{\celldownspace\textbf{\lbrack0 – 10 pkt\rbrack}} & & \\ \hline
    
    \makecell[lc]{\cellupspace\textbf{2.} Kompletność i poprawność rysunków, tabel i załączników.}
    & \multirow{2}{*}{} & \multirow{2}{*}{} \\
    
    \makecell{\celldownspace\textbf{\lbrack0 – 6 pkt\rbrack}} & & \\ \hline
    
    \makecell[lc]{\cellupspace\textbf{3.} Estetyka pracy.} & \multirow{2}{*}{} & \multirow{2}{*}{} \\
    
    \makecell{\celldownspace\textbf{\lbrack0 – 4 pkt\rbrack}} & & \\ \tabucline[1.3pt]{}
    
    \multicolumn{1}{|[1.3pt]l|[0.65pt]}{\small\textbf{\tabulinesep=1mm\hspace{5mm}\makecell[cl]{Strona edytorska łącznie \\
    (suma punktów w wierszach: 1 – 3)
    }}} 
    & \multicolumn{1}{|[0.65pt]l|[0.65pt]}{\cellcolor{gray}}
    & \multicolumn{1}{|[0.65pt]l|[1.3pt]}{\cellcolor{gray}} \\ \tabucline[1.3pt]{}
    
    \multicolumn{3}{|[1.3pt]l|[1.3pt]}{\makecell{\null}} \\ \tabucline[1.3pt]{}
    
    \multicolumn{1}{|[1.3pt]l|[0.65pt]}{\small\textbf{\tabulinesep=1.5mm\makecell{OCENA PUNKTOWA PROJEKTU \\
    (suma punktów części I i II)
    }}}
    & \multicolumn{1}{|[0.65pt]l|[0.65pt]}{\cellcolor{gray}}
    & \multicolumn{1}{|[0.65pt]l|[1.3pt]}{\cellcolor{gray}} \\ \tabucline[1.3pt]{}
    
    \multicolumn{1}{|[1.3pt]l|[0.65pt]}{\small\textbf{\tabulinesep=3mm\makecell{OCENA LICZBOWA PROJEKTU}}}
    & \multicolumn{1}{|[0.65pt]l|[0.65pt]}{\cellcolor{gray}}
    & \multicolumn{1}{|[0.65pt]l|[1.3pt]}{\cellcolor{gray}} \\ \tabucline[1.3pt]{}
  \end{tabu}
\end{center}

\vspace{2mm}\setlength{\parindent}{0em}
\textbf{\normalsize Podpis promotora \dotrule{0.46\textwidth} data \dotrule{0.25\textwidth}}\vspace{3mm}
\textbf{\normalsize Podpis recenzenta \dotrule{0.46\textwidth} data \dotrule{0.25\textwidth}}\vspace{1mm}

Skala ocen (wg Regulaminu Studiów AGH, §13, p.1)\newline
\vspace{1mm}\textbf{\underline{Liczba punktów \hspace{5mm}Ocena liczbowa i słowna}}\newline
90 – 100....................5.0  (bardzo dobry)\newline
80 – 89......................4.5  (plus dobry)\newline
70 – 79......................4.0  (dobry)\newline
60 – 69......................3.5  (plus dostateczny)\newline
50 – 59......................3.0  (dostateczny)\newline                                
<50............................2.0  (niedostateczny)
\egroup
}